Attribute VB_Name = "PrecisionID_C39_Module"

'###################################################################
'#  Visual Basic Module for PrecisionID Fonts V2.1
'#  Copyright, PrecisionID.com, Inc. 2005. All rights reserved.
'#
'#  You may incorporate our Source Code in your application
'#  only if you own a valid license from PrecisionID.com,
'#  for the associated font and no text is removed from the
'#  source code.
'#
'#  Distributing our source code or fonts outside your
'#  organization requires a Developer License.
'#
'#
'###################################################################


Private Text_Input As String
Private Text_Raw As String
Private End_Sequence As String
Private Start_Code As String
Private Stop_Code As String
Private F As Integer
Private Text_Output As String
Private Correct_Text As String
Private Printable_Text As String
Private Enc_Method As String
Private PreCheckTotal As Long
Private PreCheckVal As Integer
Private Current_Val As Long
Private Check_Val As Integer
Private Switch As Integer
Private I As Integer
Private Check_Digit As Integer
Private Current_Method As String
Private New_Line As String
Private This_Char As String
Private This_CharNum As Integer
Private Lead_Char As Integer
Private AddOn_2 As String
Private AddOn_5 As String
Private AddOn_TextFinal As String
Private HR_Text As String
Private Text_Len As Integer
Private FNC_Int As Integer
'END OF DECLARACTIONS

'Creates a Code 39 barcode with a MOD 43 check digit
Public Function PrecisionID_C39M43(Text_Input As String) As String
     'NOTE: if the end of the barcode appears truncated,
     'add two colons to the end sequence, for example:
     'End_Sequence = "::"
     End_Sequence = ""
     Text_Input = UCase(Text_Input)
     Text_Output = ""
     Correct_Text = ""
     Text_Len = Len(Text_Input)
     For I = 1 To Text_Len
          This_CharNum = (AscW(Mid(Text_Input, I, 1)))
          If This_CharNum < 58 And This_CharNum > 47 Then Correct_Text = Correct_Text & Mid(Text_Input, I, 1)
          If This_CharNum < 91 And This_CharNum > 64 Then Correct_Text = Correct_Text & Mid(Text_Input, I, 1)
          If This_CharNum = 95 Then Correct_Text = Correct_Text & Mid(Text_Input, I, 1)
          If This_CharNum = 32 Then Correct_Text = Correct_Text & ChrW(95)
          If This_CharNum = 45 Then Correct_Text = Correct_Text & Mid(Text_Input, I, 1)
          If This_CharNum = 46 Then Correct_Text = Correct_Text & Mid(Text_Input, I, 1)
          If This_CharNum = 36 Then Correct_Text = Correct_Text & Mid(Text_Input, I, 1)
          If This_CharNum = 47 Then Correct_Text = Correct_Text & Mid(Text_Input, I, 1)
          If This_CharNum = 43 Then Correct_Text = Correct_Text & Mid(Text_Input, I, 1)
          If This_CharNum = 37 Then Correct_Text = Correct_Text & Mid(Text_Input, I, 1)
     Next I
     Text_Input = Correct_Text
     PreCheckTotal = 0
     Text_Len = Len(Text_Input)
     For I = 1 To Text_Len
          This_CharNum = (AscW(Mid(Text_Input, I, 1)))
          If This_CharNum = 32 Then This_CharNum = 95
          If This_CharNum < 58 And This_CharNum > 47 Then Current_Val = This_CharNum - 48
          If This_CharNum < 91 And This_CharNum > 64 Then Current_Val = This_CharNum - 55
          If This_CharNum = 45 Then Current_Val = 36
          If This_CharNum = 47 Then Current_Val = 40
          If This_CharNum = 43 Then Current_Val = 41
          If This_CharNum = 37 Then Current_Val = 42
          If This_CharNum = 46 Then Current_Val = 37
          If This_CharNum = 36 Then Current_Val = 39
          If This_CharNum = 95 Then Current_Val = 38
          Text_Output = Text_Output & ChrW(This_CharNum)
          PreCheckTotal = PreCheckTotal + Current_Val
     Next I
     Check_Val = (PreCheckTotal Mod 43)
     If Check_Val = 36 Then Check_Digit = 45
     If Check_Val = 37 Then Check_Digit = 46
     If Check_Val = 38 Then Check_Digit = 95
     If Check_Val = 39 Then Check_Digit = 36
     If Check_Val = 40 Then Check_Digit = 47
     If Check_Val = 41 Then Check_Digit = 43
     If Check_Val = 42 Then Check_Digit = 37
     If Check_Val < 10 Then Check_Digit = Check_Val + 48
     If Check_Val < 36 And Check_Val > 9 Then Check_Digit = Check_Val + 55
     PrecisionID_C39M43 = "*" & Text_Output & ChrW(Check_Digit) & "*" & End_Sequence
End Function

'Creates a Code 39 barcode without a check digit
Public Function PrecisionID_C39(Text_Input As String) As String
     'NOTE: if the end of the barcode appears truncated,
     'add two colons to the end sequence, for example:
     'End_Sequence = "::"
     End_Sequence = ""
     Text_Output = ""
     Text_Input = RTrim(LTrim(Text_Input))
     Text_Len = Len(Text_Input)
     For I = 1 To Text_Len
          This_Char = (Mid(Text_Input, I, 1))
          If This_Char = " " Then This_Char = "_"
          Text_Output = Text_Output & This_Char
     Next I
     Printable_Text = "*" & Text_Output & "*"
     PrecisionID_C39 = Printable_Text & End_Sequence
End Function






